/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import java.util.Iterator;
import java.util.Vector;

public abstract class ADQLList<T extends ADQLObject>
implements ADQLObject,
Iterable<T> {
    private final String name;
    private final Vector<T> list = new Vector();

    protected ADQLList(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this.name = string;
    }

    protected ADQLList(ADQLList<T> aDQLList) throws Exception {
        this(aDQLList.getName());
        for (ADQLObject aDQLObject : aDQLList) {
            this.add(aDQLObject.getCopy());
        }
    }

    public boolean add(T t) throws NullPointerException {
        if (t == null) {
            throw new NullPointerException("It is impossible to add NULL items to an ADQL clause !");
        }
        return this.list.add(t);
    }

    public void add(int n, T t) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (t == null) {
            throw new NullPointerException("It is impossible to add NULL items to an ADQL clause !");
        }
        this.list.add(n, t);
    }

    public T set(int n, T t) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (t != null) {
            return (T)((ADQLObject)this.list.set(n, t));
        }
        throw new NullPointerException("It is impossible to replace an ADQL item by a NULL item into an ADQL clause !");
    }

    public T get(int n) throws ArrayIndexOutOfBoundsException {
        return (T)((ADQLObject)this.list.get(n));
    }

    public T remove(int n) throws ArrayIndexOutOfBoundsException {
        return (T)((ADQLObject)this.list.remove(n));
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toADQL() {
        StringBuffer stringBuffer = new StringBuffer(this.getName() == null ? "" : this.getName() + " ");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" " + this.getSeparator(i) + " ");
            }
            stringBuffer.append(this.get(i).toADQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLListIterator(this);
    }

    public abstract String[] getPossibleSeparators();

    public abstract String getSeparator(int var1) throws ArrayIndexOutOfBoundsException;

    @Override
    public abstract ADQLObject getCopy() throws Exception;

    public static class ADQLListIterator
    implements ADQLIterator {
        protected final ADQLList<ADQLObject> list;
        protected int index = -1;
        protected boolean removed = false;

        public ADQLListIterator(ADQLList<? extends ADQLObject> aDQLList) {
            this.list = aDQLList;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.list.size();
        }

        @Override
        public ADQLObject next() {
            this.removed = false;
            return this.list.get(++this.index);
        }

        @Override
        public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
            if (this.index <= -1) {
                throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
            }
            if (this.removed) {
                throw new IllegalStateException("The remove() has already been called !");
            }
            if (aDQLObject == null) {
                this.remove();
            } else {
                this.list.set(this.index, aDQLObject);
            }
        }

        @Override
        public void remove() {
            if (this.index <= -1) {
                throw new IllegalStateException("remove() impossible: next() has not yet been called !");
            }
            if (this.removed) {
                throw new IllegalStateException("The remove() has already been called !");
            }
            this.list.remove(this.index--);
            this.removed = true;
        }
    }
}

